/***********************************************
*  I2CʐMCu
*    lcd_init()    ----- 
*    lcd_cmd(cmd)  ----- R}ho
*    lcd_data(data) ----- P\o
*    lcd_str(ptr)  ----- \o
*    lcd_clear()   ----- S
**********************************************/
#include <htc.h>
#include "i2c_lib.h"

/*****************************
* Start Condiotion
*****************************/
void I2CStart(void)
{
	/* SCL,SDA͏펞HighƂ@*/
	SDA = 0;						// SDA Low
	TRISSDA = 0;					// SDAo
}
/*****************************
* Stop Condition 
*****************************/
void I2CStop(void)
{
	SCL = 0;						// SCL Low
	__delay_us(1);
	SDA = 0;						// SDA Low
	TRISSDA = 0;					// o̓[hɖ߂@SDA =Low
	SCL = 1;						// SCLHigh
	__delay_us(1);
	SDA = 1;						// ォSDAHigh
	__delay_us(10);
}
/****************************
* I2C1oCgo 
****************************/
unsigned char I2COut(unsigned char data)
{
	int i;
	unsigned char BitPos, ACK;

	/* Data Out */
	TRISSDA = 0;					// SDAo̓[h
	BitPos = 0x80;				// rbgʒul
	for(i=0; i<8; i++)			// 8rbgJԂ
	{
		SCL = 0;					// SCL Low
		if((data & BitPos) != 0)	// rbgo
			SDA = 1;				// SDA High
		else
			SDA = 0;				// SDA Low
		BitPos = BitPos >> 1;		// rbgʒuړ
		SCL = 1;					// SCL Highɖ߂
	}
	/* Ack `FbN */
	SCL = 0;						// NbNPLow
	TRISSDA = 1;					// ̓[hɂACK
	__delay_us(2);
	SCL = 1;						// NbNHighɖ߂
	__delay_us(2);
	ACK = SDA;					// ACK`FbN
	return(ACK);					// ACK߂lƂ
}

/*********************************
* I2CPoCg
* p[^ACK/NACԂ
*********************************/
unsigend char I2CRcv(unsigned char Ack){
	int	i;
	unsigned char BitPos,data;

	data = 0;
	BitPos = 0x80;
for(i=0;i<8;i++){
		SCL = 0;
		TRISSDA = ;
		__delay_us(3);
		SCL = 1;
		if(SDA)
			data |= BitPos;
			BitPos = BitPos >>1;
	}
	/* ACK/NAK o */
	SCL = 0;
	SDA = Ack;
	TRISSDA = 0;
	__delay_us(2);
	SCl = 1;
	return(data);
}

unsiged char I2CCmd(unsiged char addr, unsigned char RdWr){
	int unsiged char data;

	data = (addr << 1) | RfWr;
	return(I2COut(data));
}


/********* LCD֐*******/

/*********************************
* t1\f[^o
*********************************/
void lcd_data(unsigned char data)
{
	I2CStart();					// X^[g
	I2COut(0x7C);					// AhX
	I2COut(0x40);					// \f[^w
	I2COut(data);					// \f[^o
	I2CStop();					// Xgbv
	__delay_us(30);				// x
}

/*******************************
* tւPR}ho 
*******************************/
void lcd_cmd(unsigned char cmd)
{
	I2CStart();					// X^[g
	I2COut(0x7C);					// AhX
	I2COut(0x00);					// R}hw
	I2COut(cmd);					// R}ho
	I2CStop();					// Xgbv
	/* ClearHome */
	if((cmd == 0x01)||(cmd == 0x02))
		__delay_ms(2);			// 2msec҂
	else
		__delay_us(30);			// 30sec҂	
}
/*******************************
*  ֐ 
*******************************/
void lcd_init(void)
{
	delay_100ms(1);
	lcd_cmd(0x38);				// 8bit 2line Normal mode
	lcd_cmd(0x39);				// 8bit 2line Extend mode	
	lcd_cmd(0x14);				// OSC 183Hz BIAS 1/5
	/* RgXgݒ */
	lcd_cmd(0x70 + (CONTRAST & 0x0F));
	lcd_cmd(0x5C + (CONTRAST >> 4));
							// PowerIconContrast
	lcd_cmd(0x6A);				// Follower for 5.0V
// 	lcd_cmd(0x6B);				// Ffollwer for 3.3V
	delay_100ms(3);
	lcd_cmd(0x38);				// Set Normal mode 
	lcd_cmd(0x0C);				// Display On 
	lcd_cmd(0x01);				// Clear Display 
}
/******************************
* S֐
******************************/
void lcd_clear(void)
{
	lcd_cmd(0x01);				//R}ho
}
/*****************************
* \֐
*****************************/
void lcd_str(char* ptr)
{
	while(*ptr != 0)				//o 
		lcd_data(*ptr++);			//\
}

/******************************
*  100msecx֐
******************************/
void delay_100ms(unsigned int time)
{
	time *= 4;					// 4{
	while(time){
		__delay_ms(25);			// 25msec
		time--;					// 100msec x time
	}
}
