//
// Arduino UNO ダイナミック7seg表示

//=== 7seg出力ピン番号配列 ===
const int pinNum[] = { 2, 4, 8, 6, 5, 3, 9, 7 };
                            // a,b,c,d,e,f,g,dp のピン番号を順に
const int pinCom[] = { 11, 12, 10 };       // 下位の桁から

//=== 7seg表示パターンデータ ===
const int digits[] = {
  0b00111111,       // '0'
  0b00000110,       // '1'
  0b01011011,       // '2'
  0b01001111,       // '3'
  0b01100110,       // '4'
  0b01101101,       // '5'
  0b01111101,       // '6'
  0b00100111,       // '7'
  0b01111111,       // '8'
  0b01101111,       // '9'
  0b01110111,       // 'A'
  0b01111100,       // 'B'
  0b00111001,       // 'C'
  0b01011110,       // 'D'
  0b01111001,       // 'E'
  0b01110001,       // 'F'
  0b01000000        // '-'
};

//=== 7seg表示関数 ===
void numDisp( int n ) {
  for ( int w = 0; w < 7; w++ ) {
    digitalWrite( pinNum[w], bitRead( digits[n], w ));
  }
};

//=== 7seg全消灯関数 ===
void off7SegLED() {                              // com出力を全てLOWに
  for ( int i = 0; i < 3; i++ ) {
    digitalWrite( pinCom[i], LOW );
  }
};

//=== 7-Seg 全桁表示
void segDisp( int n ) {
  for ( int i = 0; i < 3; i++ ) {
    off7SegLED();                               // 全ての表示を一端消す
    numDisp( n % 10 );                          // 7segデータのセット　　　　　　　
    digitalWrite( pinCom[i], HIGH );            // その桁のみ表所ON
    n = n / 10;                                 // 1桁右ずらす
    delay( 5 );                                 // 表示を安定させるため
  }
}

//=== 数値カウンタ ===:
int numCounter = 0;                            // 数値カウンタ

//==== 初期設定 =====
void setup() {
  Serial.begin( 9600 );
  for ( int i = 0; i < 8; i++ ) {
    pinMode( pinNum[i], OUTPUT );               // LED出力ピン宣言
  }
  for ( int i = 0; i < 3; i++ ) {
    pinMode( pinCom[i], OUTPUT );              // コモンピンを宣言
  }
  off7SegLED();
  segDisp( numCounter );                       // 7segに000を表示
};

// === メインループ ===
void loop() {
  Serial.println(numCounter);
  for (int i=0; i<10; i++){
    segDisp( numCounter );
    delay(10);
  }
  numCounter++;
  if ( numCounter > 999 ) numCounter = 0;
}


