#include <Wire.h> 
 
// pin:接続 for AQM0802A
// 1: LCD_VCC = 3.3V,or 5V
// 3: LCD_CL = UNO_ADC5　（PullUp必要）
// 4: LCD_DA = UNO_ADC4　（PullUp必要）
// 5: LCD_GND = GND 
 
#define LCDA 0x3E         //lcd address AQM0802

//使用電源によりどちらか選択 
#define BOOST 0x04       //for 3.3V AQM0802 
//#define BOOST 0x00       //for 5.0V AQM0802 

int  contrast = 0x20;    // defalt contrast
char lcdbuf[10]="";      // 8文字＋２
byte val = 0; 
char Msg[17] = "I2C LCD"; 
 
void setup(){ 
  Serial.begin(9600); 
  delay(100); 
  Wire.begin();  
  lcd_begin();                  //初期設定 
  Serial.println("setup"); 
} 
 
void loop() 
{ 
  lcd_setCursor(0,0);     //カーソルを0行に位置設定 
  lcd_print(Msg);         //文字列表示 
  lcd_setCursor(0,1);     //カーソルを1行に位置設定 
  lcd_print(val);         //数字を表示 
  val++; 
  Serial.println("."); 
  delay(500); 
} 

// 液晶へ１コマンド出力 
void lcd_cmd(byte cmd){ 
  Wire.beginTransmission(LCDA); 
  Wire.write(0x00);             // コマンド指定 
  Wire.write(cmd);              // コマンド出力 
  Wire.endTransmission();       // ストップ 
/* ClearかHomeか */ 
  if((cmd == 0x01)||(cmd == 0x02)) 
    delay(2);                   // 2msec待ち 
  else 
    delayMicroseconds(30);      // 30μsec待ち 
} 
 
// 液晶へデータを送る 
void lcd_data(byte data){ 
  Wire.beginTransmission(LCDA); // スタート 
  Wire.write(0x40);             // 表示データ指定 
  Wire.write(data);             // 表示データ出力 
  Wire.endTransmission();       // ストップ 
  delayMicroseconds(30);        // 遅延 
} 
 
void lcd_setCursor(byte clm,byte row){ 
  if(row==0) lcd_cmd(0x80+clm); 
  if(row==1) lcd_cmd(0xc0+clm); 
} 
 
// 初期化 ( begin I2C master )
void lcd_begin(void){ 
  Serial.println("lcd_begin"); 
  delay(10); 
  lcd_cmd(0x38);          // 8bit 2line Normal mode 
  lcd_cmd(0x39);          // 8bit 2line Extend mode 
  lcd_cmd(0x14);          // OSC 183Hz BIAS 1/5 
 
// コントラスト設定（下位4bit、上位2bitに分割） 
  lcd_cmd((byte)(0x70 + (contrast & 0x0F))); 
  lcd_cmd((byte)(0x58 + BOOST + (contrast >> 4)));
  lcd_cmd((byte)0x6B);        // Follwer for 3.3V 
  delay(1); 
 
  lcd_cmd((byte)0x38);        // Set Normal mode 
  lcd_cmd((byte)0x0C);        // Display On 
  lcd_cmd((byte)0x01);        // Clear Display 
  delay(1); 
  Serial.println("end of lcd_begin"); 
} 
 
//全消去関数 
void lcd_clear(void){ 
  lcd_cmd(0x01);              //全消去コマンド出力 
  delay(2); 
} 
 
//文字列表示関数 
void lcd_print(char* ptr){ 
  while(*ptr != 0)            //文字取り出し 
    lcd_data(*ptr++);         //文字表示 
} 
 
void lcd_print(int num){ 
   sprintf(lcdbuf,"%d",num); 
   lcd_print(lcdbuf); 
} 

