// リアルタイムクロック( rtc-8564nb + LCD , SCL=A5 SDA=A4 )

#include <Wire.h>
#define LCD_Adr    0x3E             // LCDのアドレス
#define RTC_Adr    0x51             // RTCのアドレス
#define MdBtn_Pin  6                // モード選択ボタンピン
#define R_CMND_1   0
#define R_CMND_2   1
#define R_SECONDS  2
#define R_MINUTES  3
#define R_HOURS    4 
#define R_DAYS     5
#define R_WEEKS    6
#define R_MONTHS   7
#define R_YEARS    8

int seconds   = 50;                  // RTC初期値設定
int minutes   = 59;
int hours     = 23;
int days      = 31;
int weeks     =  6;                  // 6：土曜日
int months    = 12;
int years     = 16;
char t_buf[10]= "";                  // 表示データ用バッファ
int  d_md     = 0;                   // 秒表示モード
char *wk_dt[] ={ "sun","mon","tue","wed","thu","fri","sat" };

//********* setup ***********
void setup(){
  Serial.begin(9600);               // シリアルモニタON
  pinMode(13, OUTPUT); 
  pinMode(MdBtn_Pin, INPUT_PULLUP);  // モード選択ボタン
  Wire.begin();                      // I2C通信開始
  delay(1);
  rtc_begin();                       // RTCの初期化
  lcd_begin();                       // LCDの初期化
  Serial.println("-- setup end"); 
}

//********* main loop ***********
void loop(){
  digitalWrite(13, HIGH);
  if ( digitalRead(MdBtn_Pin) == LOW ){;
    switch ( d_md ){
      case 0:  d_md = 1; break;     // 曜日表示モードへ
      case 1:  d_md = 0; break;     // 秒表示モードへ
    }
    while( digitalRead(MdBtn_Pin) == LOW ); // highまで待つ
  }
  rtc_read_data();                  // RTCからデータを読む 
  sprintf( t_buf,"%02d/%02d/%02d",years,months,days );
  lcd_setCursor(0,0);               // カーソルを0行目の先頭に
  lcd_print(t_buf);                 // LCDに年月日を表示
//  Serial.println( t_buf );        // RTCテスト確認用
  switch ( d_md ){
    case 0:
      sprintf( t_buf,"%02d:%02d:%02d",hours,minutes,seconds );
      break;
    case 1:
      sprintf( t_buf,"%02d:%02d%3s",hours,minutes,wk_dt[weeks] );
      break;   
  }
  lcd_setCursor(0,1);               // カーソルを1行目の先頭に
  lcd_print(t_buf);                 // LCDに時分秒を表示     
  Serial.println( t_buf );        // RTCテスト確認用 
  digitalWrite(13, LOW);
  delay(100);
}

//********* BCD <-> Binary ( 1 byte用 ) *******
unsigned int bcd2bin(char dt){
  return (( dt >> 4 ) * 10 ) + ( dt & 0x0F);
}

unsigned int bin2bcd(unsigned num){
  num = num % 100;                  // numは0～99
  return (( num / 10 ) << 4 )| ( num % 10 );
}

//***** リアルタイムクロック *******

void rtc_write(byte adr, byte data){
  Wire.beginTransmission(RTC_Adr);
  Wire.write(adr);                  // アドレス指定
  Wire.write(data);                 // データ書込み
  Wire.endTransmission();
  delay(1);  
}

int rtc_read(byte adr){
  Wire.beginTransmission(RTC_Adr);
  Wire.write(adr);                  // アドレス指定
  Wire.endTransmission();
  Wire.requestFrom(RTC_Adr,1);      // データ1バイト送信要求
  return Wire.read();               // データ取得
}

void rtc_write_data(){
  rtc_write(R_SECONDS,bin2bcd(seconds));   // 秒
  rtc_write(R_MINUTES,bin2bcd(minutes));   // 分
  rtc_write(R_HOURS,  bin2bcd(hours));     // 時
  rtc_write(R_DAYS,   bin2bcd(days));      // 日
  rtc_write(R_WEEKS,  bin2bcd(weeks));     // 曜日
  rtc_write(R_MONTHS, bin2bcd(months));    // 月
  rtc_write(R_YEARS,  bin2bcd(years));     // 年  
}

void rtc_read_data(void){
  seconds = bcd2bin( rtc_read(R_SECONDS) & 0x7F );  // 秒
  minutes = bcd2bin( rtc_read(R_MINUTES) & 0x7F );  // 分
  hours   = bcd2bin( rtc_read(R_HOURS)   & 0x3F );  // 時
  days    = bcd2bin( rtc_read(R_DAYS)    & 0x3F );  // 日
  weeks   = bcd2bin( rtc_read(R_WEEKS)   & 0x07 );  // 曜日
  months  = bcd2bin( rtc_read(R_MONTHS)  & 0x1F );  // 月
  years   = bcd2bin( rtc_read(R_YEARS) );           // 年
}

void rtc_begin(void){               // クロック初期値設定
  Serial.println("RTC_begin");   
  rtc_write(R_CMND_1, 0x00);        // 時計機能ON
  rtc_write(R_CMND_2, 0x00);        // タイマーOFF
  Serial.println(weeks);   
  weeks = subZeller( 2000 + years, months, days );
  rtc_write_data();
  delay(1);   
}

int subZeller(int y, int m, int d ){
    if(m <3) { y--;  m += 12;  }
    return (y + y/4 - y/100 + y/400 + (13*m + 8 )/5 + d )%7;
  }

//***** 液晶表示　********（使用電源によりどちらか選択） 
//#define BOOST 0x04            // 3.3V用 AQM0802 
  #define BOOST 0x00            // 5.0V用 AQM0802 

int  contrast = 0x20;           // コントラスト初期値

void lcd_cmd(byte cmd){ 
  Wire.beginTransmission(LCD_Adr); 
  Wire.write(0x00);             // コマンド指定 
  Wire.write(cmd);              // コマンド出力 
  Wire.endTransmission();       // ストップ 
  if((cmd == 0x01)||(cmd == 0x02)) // ClearかHomeか 
    delay(2);                   // 2msec待ち 
  else 
    delayMicroseconds(30);      // 30μsec待ち 
} 
 
void lcd_data(byte data){ 
  Wire.beginTransmission(LCD_Adr); // スタート 
  Wire.write(0x40);             // 表示データ指定 
  Wire.write(data);             // 表示データ出力 
  Wire.endTransmission();       // ストップ 
  delayMicroseconds(30);        // 遅延 
} 
 
void lcd_setCursor(byte clm,byte row){ 
  if(row==0) lcd_cmd(0x80+clm);  // カーソル位置 
  if(row==1) lcd_cmd(0xc0+clm); 
} 

void lcd_begin(void){            // LCDの初期化 
  Serial.println("LCD_begin"); 
  delay(10); 
  lcd_cmd(0x38);          // 8ビット2行 標準モード 
  lcd_cmd(0x39);          // 8ビット2行 拡張モード 
  lcd_cmd(0x14);          // OSC 183Hz BIAS 1/5 
  lcd_cmd((byte)(0x70 + (contrast & 0x0F))); 
  lcd_cmd((byte)(0x58 + BOOST + (contrast >> 4)));
  lcd_cmd((byte)0x6B);        // Follwer for 3.3V 
  delay(1); 
  lcd_cmd((byte)0x38);        // 標準モードへ 
  lcd_cmd((byte)0x0C);        // 表示開始 
  lcd_cmd((byte)0x01);        // 画面消去 
  delay(1); 
} 
 
void lcd_clear(void){ 
  lcd_cmd(0x01);              // 全消去コマンド出力 
  delay(2); 
} 
 
void lcd_print(char* ptr){    // 文字列表示関数 
  while(*ptr != 0)            // 文字取り出し 
    lcd_data(*ptr++);         // 文字表示 
} 
 
void lcd_print(int num){     // 整数表示関数
   sprintf(t_buf,"%d",num); 
   lcd_print(t_buf); 
} 
