import csv
from datetime import datetime as dt
import matplotlib.pyplot as plt
from matplotlib.dates import DateFormatter

dtFormat =  '%y-%m-%d %H:%M:%S'
time=[]
temp=[]

with open('tempdata.csv','r') as f:
    rd = csv.reader(f)
    for row in rd:
        print(row)
        trstime = dt.strptime(row[0], dtFormat)
        time.append(trstime)
        temp.append(float(row[1]))
#    print(time)
#    print(temp)

fig, ax = plt.subplots()
ax.plot(time, temp, color="red")
plt.title("Temperature Plot Test")
plt.xlabel('time')
plt.ylabel('tmp(c)')

myFmt = DateFormatter("%H:%M")
ax.xaxis.set_major_formatter(myFmt)

# Rotate date labels automatically
fig.autofmt_xdate()
plt.show()
