#-*- coding:utf-8 -*-
import RPi.GPIO as GPIO
import time
 
GPIO.setmode(GPIO.BCM)
GPIO.setwarnings(False)
mPin = [17, 22, 23, 24 ]   # pink, orange, blue, yellow

StepCount = 8
Seq = [ [1,0,0,1], [1,0,0,0], [1,1,0,0], [0,1,0,0],
        [0,1,1,0], [0,0,1,0], [0,0,1,1], [0,0,0,1] ]

#GPIO.setup(enable_pin, GPIO.OUT)
for pin in range(0,4):
    GPIO.setup(mPin[pin], GPIO.OUT)

def setStep(st, delay):         #シーケンスを出力
    for k in range(0,4):
        GPIO.output(mPin[k], Seq[st][k])
    time.sleep(delay)

def forward(delay, steps):      #CW方向に回転
    print("--- forward --> ",steps)
    for i in range(steps):
        for j in range(StepCount):
            setStep(j, delay)

def backwards(delay, steps):    #CCW方向に回転
    print("--- Backward --> ",steps)
    for i in range(steps):
        for j in reversed(range(StepCount)):
            setStep(j, delay)

try:
    while True:
        delay = int(input("Time Delay (ms)?"))
        if(delay<2):
            break
        steps = int(input("How many steps ? "))
        if ( steps > 0 ):
            forward(int(delay) / 1000.0, int(steps))
        else:
            backwards(int(delay) / 1000.0, int(-steps))

except KeyboardInterrupt:
    pass
finally:
    GPIO.cleanup
