import webiopi
import pigpio
webiopi.setDebug()
GPIO = webiopi.GPIO
pi = pigpio.pi()

Pan  = 17      # 左右サーボ接続ピン
Tlt  = 18      # 上下サーボ接続ピン

Pan_hm  = 1500
Tlt_hm  = 1500
Pan_pos = Pan_hm   # サーボの現在位置
Tlt_pos = Tlt_hm
Pan_stp = 100      # 1回の移動量
Tlt_stp = 50
Pan_max = 2000     # 動作は少なめに
Pan_min = 1000
Tlt_max = 1700     # 動作は少なめに
Tlt_min = 1200

#初期化関数　GPIOを出力モードに設定
def setup():
    GPIO.setFunction(Pan, GPIO.PWM)
    GPIO.setFunction(Tlt, GPIO.PWM)
    pi.set_servo_pulsewidth(Pan, Pan_hm)
    pi.set_servo_pulsewidth(Tlt, Tlt_hm)

#マクロ関数
@webiopi.macro
def home():
    global Pan_pos, Tlt_pos
    Pan_pos = Pan_hm
    Tlt_pos = Tlt_hm
    pi.set_servo_pulsewidth(Pan, Pan_pos)
    pi.set_servo_pulsewidth(Tlt, Tlt_pos)

@webiopi.macro
def right():     # 動きが逆なら関数名をleftに
    global Pan_pos
    if Pan_pos < Pan_max:
        Pan_pos += Pan_stp
        pi.set_servo_pulsewidth(Pan, Pan_pos)

@webiopi.macro
def left():     # 動きが逆なら関数名をrightに
    global Pan_pos
    if Pan_pos > Pan_min:
        Pan_pos -= Pan_stp
        pi.set_servo_pulsewidth(Pan, Pan_pos)

@webiopi.macro
def down():     # 動きが逆なら関数名をupに
    global Tlt_pos
    if Tlt_pos < Tlt_max:
        Tlt_pos += Tlt_stp
        pi.set_servo_pulsewidth(Tlt, Tlt_pos)

@webiopi.macro
def up():     # 動きが逆なら関数名をdownに
    global Tlt_pos
    if Tlt_pos > Tlt_min:
        Tlt_pos -= Tlt_stp
        pi.set_servo_pulsewidth(Tlt, Tlt_pos)

#終了関数　GPIOのPWMモードを解除
def destory():
    GPIO.setup(Pan, GPIO.IN)
    GPIO.setup(Tlt, GPIO.IN)
